; Was decimal bytes for "Machine Music Demo" by Brett Bilbrey
; from grayscale scan (with BALLY-Basic loader program) at:
; http://ballyalley.com/type-in_programs/basic/Machine_Music_Demo.pdf
; to be taped to 300-baud tape and then ran with ":RUN <GO>"
; note: PUSHes $4000 as fake RETurn address, loads 128 bytes.
;
; Music originally from #6001 Arcade-/System-/Dealer-Demo at:
; http://www.ballyalley.com/ml/ml_source/bally_demo_cart.pdf
; by Scot Norris [George Moses changed values for AstroBasic
; see program: Arcadian vol. 4, issue 01, pages 10 and 11.]
;
; Bytes converted into this Machine Code Source Assembly on:
; October 16th, 2011 by: Richard C Degler, Indianapolis, IN
; note: added HVG & Label names, and aligned random columns.
; Also changed decimal numbers to Motorola's "$xx" notation.
;

        NOLIST
        INCLUDE "HVGLIB.H"

; one BALLY Basic EQUate
CHKIO   EQU     $2D9D

        LIST
        ORG     NORMEM

; move Z-80 user Stack on-screen ?? [SYSRAM would be better !!]
        LD      SP,$4500        ; 17664 [pixel line 32, why ??]

; [arrived here with HL = $4080 but NOT all the score loaded]
        LD      BC,$0175        ; 373 bytes [to get the rest]
M_LOOP:
        PUSH    HL
        PUSH    BC
        CALL    CHKIO           ; do BallyBasic CHecK I/O at 11677
        POP     BC
        POP     HL
        LD      (HL),A          ; save character read from tape
        INC     HL
        DEC     BC              ; until BC counts down to zero
        LD      A,B
        OR      C
        JR      NZ,M_LOOP               ; 242 Decimal (-$0E)
        ;
; [finished, do what a :RETURN would do, without the INIT0 part]
        LD      A,$08
        OUT     (INMOD),A       ; port 14 [$0E] for Screen Ints ONLY
        SYSTEM  EMUSIC          ; UPI End playing MUSIC
        ;
        SYSTEM  ACTINT          ; UPI ACTivate sub timer INTerrupts
        ;
        SYSSUK  BMUSIC          ; UPI Begin playing MUSIC
        DW      $41FB           ; ... Music Stack = 16891 [END + 6 ??]
        DB      11000000B       ; ... Voices = TC only
        DW      MSCORE          ; ... Score Address = 16422 [$4026]
        ;
M_HALT:
        HALT
        JR      M_HALT                  ; 253 Decimal (-$03)

;
; J.S. Bach's Allemande (from Partitas for the Piano) score
;
; column: Duration=,TC=,TB=,TA=
MSCORE:
        MASTER  OA3             ; MO = 35 [$23]
        VOLUME  $07,$00
        NOTE1   $0A, F3
;
        VOICEM  11110000B       ; Two note music
        VOLUME  $77,$00
        LEGSTA                  ; Two notes merges together
        NOTE2   $0A,AS0, F3
        NOTE2   $0A,AS0, D3
        NOTE2   $0A,AS0,AS2
        NOTE2   $0A,AS0, A2
;
        VOICEM  11000000B       ; One note music
        VOLUME  $0C,$00
        NOTE1   $0A,AS2
        NOTE1   $0A, D3
        NOTE1   $0A, F2
        NOTE1   $0A,AS2
        NOTE1   $0A, D2
        NOTE1   $0A, F2
        NOTE1   $0A,AS1
        NOTE1   $0A, D2
        NOTE1   $0A, F2
        NOTE1   $0A,GS2
        NOTE1   $0A, D3
        NOTE1   $0A, F3
;
        VOLUME  $77,$00
        VOICEM  11110000B       ; Two note music
        NOTE2   $0A,AS0, G3
        NOTE2   $0A,AS0,DS3
        NOTE2   $0A,AS0,AS2
        NOTE2   $0A,AS0, A2
;
        VOICEM  11000000B       ; One note music
        VOLUME  $0C,$00
        NOTE1   $0A,AS2
        NOTE1   $0A,DS3
        NOTE1   $0A, G2
        NOTE1   $0A,AS2
        NOTE1   $0A,DS2
        NOTE1   $0A, G2
        NOTE1   $0A,AS1
        NOTE1   $0A,DS2
        NOTE1   $0A, G2
        NOTE1   $0A,AS2
        NOTE1   $0A,DS3
        NOTE1   $0A, G3
;
        VOLUME  $77,$00
        VOICEM  11110000B       ; Two voice music
        NOTE2   $0A,AS0, A3
        NOTE2   $0A,AS0,DS3
        NOTE2   $0A,AS0, C3
        NOTE2   $0A,AS0,AS2
;
        VOICEM  11000000B       ; One note music
        VOLUME  $0C,$00
        NOTE1   $0A, C3
        NOTE1   $0A,DS3
        NOTE1   $0A, A2
        NOTE1   $0A, C3
        NOTE1   $0A,DS2
        NOTE1   $0A, A2
        NOTE1   $0A, C2
        NOTE1   $0A,DS2
        NOTE1   $0A, A2
        NOTE1   $0A, C3
        NOTE1   $0A,DS3
        NOTE1   $0A, A3
;
        VOICEM  11110000B       ; Two note music
        VOLUME  $77,$00
        NOTE2   $0A,AS0,AS3
        NOTE2   $0A,AS0, F3
        NOTE2   $0A,AS0, D3
        NOTE2   $0A,AS0, C3
;
        VOICEM  11000000B       ; One note music
        VOLUME  $0C,$00
        NOTE1   $0A, D3
        NOTE1   $0A, F3
        NOTE1   $0A,AS2
        NOTE1   $0A, D3
        NOTE1   $0A, F2
        NOTE1   $0A,AS2
        NOTE1   $0A, D2
        NOTE1   $0A, F2
        NOTE1   $0A,AS1
        NOTE1   $0A, G2
        NOTE1   $0A, A1
        NOTE1   $0A, F2
;
        VOICEM  11111100B       ; Three note music
        VOLUME  $77,$06
        NOTE3   $0A,AS0, G1, G1
        NOTE3   $0A,AS0, G1, C3
        NOTE3   $0A,AS0, G1, E2
        NOTE3   $0A,AS0, G1, D2
;
        VOICEM  11000000B       ; One note music
        VOLUME  $0C,$00
        NOTE1   $0A, E2
        NOTE1   $0A, G2
        NOTE1   $0A, C2
        NOTE1   $0A, E2
;
        VOICEM  11111100B       ; Three note music
        VOLUME  $77,$07
        NOTE3   $0A, A0,FS1,FS1
        NOTE3   $0A, A0,FS1, A1
        NOTE3   $0A, A0,FS1, C2
        NOTE3   $0A, A0,FS1,DS2
;
        VOICEM  11000000B       ; One note music
        VOLUME  $0C,$00
        NOTE1   $0A, D2
        NOTE1   $0A, C2
        NOTE1   $0A, C3
        NOTE1   $0A, D2
;
        VOICEM  11111100B       ; Three note music
        VOLUME  $77,$06
        NOTE3   $0A, G0, G1,DS2
        NOTE3   $0A, G0, G1, G2
        NOTE3   $0A, G0, G1, C3
        NOTE3   $0A, G0, G1, B2
;
        VOICEM  11000000B       ; One note music
        VOLUME  $0C,$00
        NOTE1   $0A, C3
        NOTE1   $0A,DS3
        NOTE1   $0A, A2
        NOTE1   $0A, C3
        NOTE1   $0A,FS2
        NOTE1   $0A, A2
        NOTE1   $0A, C3
        NOTE1   $0A,DS3
        NOTE1   $0A, D3
        NOTE1   $0A, C3
        NOTE1   $0A, A3
        NOTE1   $0A, C3
;
        VOICEM  11110000B       ; Two note music
        VOLUME  $AA,$00
        NOTE2   $0A, G0, G0
        NOTE2   $0A, G0, C3
        NOTE2   $0A, G1,AS2
        NOTE2   $0A, G1, A2
        NOTE2   $0A, G1,AS2
        NOTE2   $0A, G1, D3
        NOTE2   $0A, F1, E3
        NOTE2   $0A, F1, F3
        NOTE2   $0A, E1, G3
        NOTE2   $0A, E1, C3
        NOTE2   $0A, E2,AS2
        NOTE2   $0A, E2, A2
        NOTE2   $0A, E2,AS2
        NOTE2   $0A, E2, G3
        NOTE2   $0A, D2,AS2
        NOTE2   $0A, D2, F3
        NOTE2   $0A, C2,AS2
        NOTE2   $0A, C2, F3
        NOTE2   $0A, C1, E3
        NOTE2   $0A, C1, D3
        NOTE2   $0A, C1, E3
        NOTE2   $0A, C1, G3
        NOTE2   $0A,AS0, A3
        NOTE2   $0A,AS0,AS3
        NOTE2   $0A, A0, C4
        NOTE2   $0A, A0, F3
        NOTE2   $0A, A1, E3
        NOTE2   $0A, A1, D3
        NOTE2   $0A, A1, E3
        NOTE2   $0A, A1, C4
        NOTE2   $0A, G1, E3
        NOTE2   $0A, G1,AS3
        VOLUME  $55,$00
        NOTE2   $0A, F1, E3
        NOTE2   $0A, F1,AS3
        NOTE2   $0A, F2, A3
        NOTE2   $0A, F2, G3
        NOTE2   $0A, A2, F3
        NOTE2   $0A, A2, A3
        NOTE2   $0A, C3, E3
        NOTE2   $0A, C3, A3
        NOTE2   $0A,AS2, D3
        NOTE2   $0A,AS2, A3
        NOTE2   $0A,AS1, D3
        NOTE2   $0A,AS1, C3
        NOTE2   $0A, D2,AS2
        NOTE2   $0A, D2, D3
        NOTE2   $0A, F2, A2
        NOTE2   $0A, F2, D3
        QUIET
;

; L41F5:  used 501 bytes total

        END

